'
' Command to delete a string from a document.
'
Public Class DeleteCommand
    Implements ICommand
    Private document As Document ' The document to insert into
    Private position As Integer ' The position to insert at
    Private length As Integer ' The length of the string to delete
    Private delstr As String  ' The string that was deleted

    '
    ' Constructor
    '
    ' document - The document to delete from
    ' position - The position to delete from
    ' length - The length of the string to delete
    Public Sub New(ByVal document As Document, ByVal position As Integer, ByVal length As Integer)
        Me.document = document
        Me.position = position
        Me.length = length
    End Sub 'New

    ' Constructor(Document, int, int)
    ' Perform the command encapsulated by this object.
    '
    ' returns - true if this call to doIt was successful and can be undone
    Public Function DoIt() As Boolean _
    Implements ICommand.DoIt
        Try
            delstr = document.GetString(position, length)
            document.DeleteCommand(position, length)
        Catch
            Return False
        End Try
        Return True
    End Function 'DoIt

    ' Undo the command encapsulated by this object. 
    ' return true if the undo was successful
    Public Function UndoIt() As Boolean _
    Implements ICommand.UndoIt
        Try
            document.InsertStringCommand(position, delstr)
        Catch
            Return False
        End Try
        Return True
    End Function
End Class 'DeleteCommand
